unit Unit1;

interface

uses
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    Db, DBTables, Grids, DBGrids, ExtCtrls, DBCtrls, StdCtrls, ExDBGrid,
    RXCombos;

type
    TForm1 = class(TForm)
        DBNavigator1: TDBNavigator;
        Table1: TTable;
        DataSource1: TDataSource;
        Panel1: TPanel;
        Button1: TButton;
        Button2: TButton;
        Button3: TButton;
        Button4: TButton;
        Button5: TButton;
        ExDBGrid1: TExDBGrid;
        Button6: TButton;
        Button7: TButton;
        Button8: TButton;
        Button9: TButton;
        Panel2: TPanel;
        Panel3: TPanel;
        Button10: TButton;
        Button12: TButton;
        Button11: TButton;
        ColorComboBox1: TColorComboBox;
        Label1: TLabel;
        Label2: TLabel;
        ColorComboBox2: TColorComboBox;
        Label3: TLabel;
        ColorComboBox3: TColorComboBox;
        Button13: TButton;
        Button14: TButton;
        Button15: TButton;
        Button16: TButton;
        procedure Button1Click(Sender: TObject);
        procedure Button2Click(Sender: TObject);
        procedure Button3Click(Sender: TObject);
        procedure ExDBGrid1ApplyCellAttribute(Sender: TObject; Field: TField; Canvas: TCanvas; State: TGridDrawState);
        procedure FormCreate(Sender: TObject);
        procedure Button4Click(Sender: TObject);
        procedure Button5Click(Sender: TObject);
        procedure Button6Click(Sender: TObject);
        procedure Button7Click(Sender: TObject);
        procedure Button8Click(Sender: TObject);
        procedure Button9Click(Sender: TObject);
        procedure ExDBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
        procedure Button10Click(Sender: TObject);
        procedure Button12Click(Sender: TObject);
        procedure Button11Click(Sender: TObject);
        procedure ColorComboBox1Change(Sender: TObject);
        procedure Button13Click(Sender: TObject);
        procedure Button14Click(Sender: TObject);
        procedure Button15Click(Sender: TObject);
        procedure Button16Click(Sender: TObject);
    private
        { Private declarations }
    public
        { Public declarations }
    end;

var
    Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    ExDBGrid1.Perform(wm_Paint, 0, 0);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    if Button1.Caption = 'Autosize Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoSize := True;
            Table1.EnableControls;
            Button1.Caption := 'Autosize On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoSize := False;
            Table1.EnableControls;
            Button1.Caption := 'Autosize Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    if Button2.Caption = 'FullSizeMemo Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.FullSizeMemo := True;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.FullSizeMemo := False;
            Table1.EnableControls;
            Button2.Caption := 'FullSizeMemo Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    if Button3.Caption = 'FlatStyle On' then
        begin
            Table1.DisableControls;
            ExDBGrid1.Cells3D := True;
            Table1.EnableControls;
            Button3.Caption := 'Cells3D On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.Cells3D := False;
            Table1.EnableControls;
            Button3.Caption := 'FlatStyle On'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.ExDBGrid1ApplyCellAttribute(Sender: TObject;
    Field: TField; Canvas: TCanvas; State: TGridDrawState);
begin
    if Field = Table1.Fields[0] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clBlue;

    if Field = Table1.Fields[1] then
        if not (gdSelected in State) then
            Canvas.Font.Color := clRed;

    if Field = Table1.Fields[2] then
        Canvas.Font.Style := Canvas.Font.Style + [fsBold];

    if Field = Table1.Fields[3] then
        if not (gdSelected in State) then
            begin
                Canvas.Brush.Style := bsSolid;
                Canvas.Brush.Color := clGreen;
            end;

    if Field = Table1.Fields[4] then
        if Table1.Fields[4].AsInteger > 30 then
            if not (gdSelected in State) then
                Canvas.Font.Color := clYellow;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    if Button4.Caption = 'OptWidth Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.Align := alNone;
            ExDBGrid1.Width := ExDBGrid1.OptWidth;
            Table1.EnableControls;
            Button4.Caption := 'OptWidth On';
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.Align := alClient;
            Table1.EnableControls;
            Button4.Caption := 'OptWidth Off';
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
    if Button5.Caption = 'CellHints Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.CellHints := True;
            Table1.EnableControls;
            Button5.Caption := 'CellHints On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.CellHints := False;
            Table1.EnableControls;
            Button5.Caption := 'CellHints Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
    if Button6.Caption = 'UseRowColors Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.UseRowColors := True;
            Table1.EnableControls;
            Button6.Caption := 'UseRowColors On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.UseRowColors := False;
            Table1.EnableControls;
            Button6.Caption := 'UseRowColors Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
    if Button7.Caption = 'MultiLineTitles Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.MultiLineTitles := True;
            Table1.EnableControls;
            Button7.Caption := 'MultiLineTitles On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.MultiLineTitles := False;
            Table1.EnableControls;
            Button7.Caption := 'MultiLineTitles Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
    if Button8.Caption = 'UseBackgroundPicture Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.UseBackgroundPicture := True;
            Table1.EnableControls;
            Button8.Caption := 'UseBackgroundPicture On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.UseBackgroundPicture := False;
            Table1.EnableControls;
            Button8.Caption := 'UseBackgroundPicture Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
    if Button9.Caption = 'AutoWidth Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoWidth := True;
            Table1.EnableControls;
            Button9.Caption := 'AutoWidth On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.GridAutoWidth := False;
            Table1.EnableControls;
            Button9.Caption := 'AutoWidth Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.ExDBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn;
    State: TGridDrawState);
begin
    if gdFocused in State then
        begin
            Panel2.Caption := 'Cell [Col, Row] = ' + Format('%d, %d', [ExDBGrid1.Col, ExDBGrid1.Row])
                + '  TopRow = ' + IntToStr(ExDBGrid1.TopRow)
                + '  LeftCol = ' + IntToStr(ExDBGrid1.LeftCol)
                + '  FixedCols = ' + IntToStr(ExDBGrid1.FixedCols)
                + '  FixedRows = ' + IntToStr(ExDBGrid1.FixedRows)
                + '  ColCount = ' + IntToStr(ExDBGrid1.ColCount)
                + '  RowCount = ' + IntToStr(ExDBGrid1.RowCount);

            Panel3.Caption := 'VisibleColCount = ' + IntToStr(ExDBGrid1.VisibleColCount)
                + '  VisibleRowCount = ' + IntToStr(ExDBGrid1.VisibleRowCount)
                + '  GridHeight = ' + IntToStr(ExDBGrid1.GridHeight)
                + '  GridWidth = ' + IntToStr(ExDBGrid1.GridWidth)
                + '  Height = ' + IntToStr(ExDBGrid1.Height)
                + '  Width = ' + IntToStr(ExDBGrid1.Width);
        end;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
    if Assigned(ExDBGrid1.OnApplyCellAttribute) then
        begin
            ExDBGrid1.OnApplyCellAttribute := nil;
            ExDBGrid1.SetFocus;
            ExDBGrid1.Invalidate;
        end
    else
        begin
            ExDBGrid1.OnApplyCellAttribute := ExDBGrid1ApplyCellAttribute;
            ExDBGrid1.SetFocus;
            ExDBGrid1.Invalidate;
        end;
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
    ExDBGrid1.ExportGrid(ExtractFilePath(Application.ExeName) + 'Test.Dat');
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
    if Button11.Caption = 'DrawFocusRect Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.DrawFocusRect := True;
            Table1.EnableControls;
            Button11.Caption := 'DrawFocusRect On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.DrawFocusRect := False;
            Table1.EnableControls;
            Button11.Caption := 'DrawFocusRect Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.ColorComboBox1Change(Sender: TObject);
begin
    ExDBGrid1.HighlightColor := ColorComboBox1.ColorValue;
    ExDBGrid1.ImageHighlightColor := ColorComboBox2.ColorValue;
    ExDBGrid1.HighlightFontColor := ColorComboBox3.ColorValue;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
    if Button13.Caption = 'EnterAsTab Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.EnterAsTab := True;
            Table1.EnableControls;
            Button13.Caption := 'EnterAsTab On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.EnterAsTab := False;
            Table1.EnableControls;
            Button13.Caption := 'EnterAsTab Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
    if Button14.Caption = 'AllowAutoAppend Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.AllowAutoAppend := True;
            Table1.EnableControls;
            Button14.Caption := 'AllowAutoAppend On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.AllowAutoAppend := False;
            Table1.EnableControls;
            Button14.Caption := 'AllowAutoAppend Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button15Click(Sender: TObject);
begin
    if Button15.Caption = 'FlatCheckBox Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.FlatCheckBox := True;
            Table1.EnableControls;
            Button15.Caption := 'FlatCheckBox On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.FlatCheckBox := False;
            Table1.EnableControls;
            Button15.Caption := 'FlatCheckBox Off'
        end;
    ExDBGrid1.SetFocus;
end;

procedure TForm1.Button16Click(Sender: TObject);
begin
    if Button16.Caption = 'SearchMode Off' then
        begin
            Table1.DisableControls;
            ExDBGrid1.SearchMode := True;
            Table1.EnableControls;
            Button16.Caption := 'SearchMode On'
        end
    else
        begin
            Table1.DisableControls;
            ExDBGrid1.SearchMode := False;
            Table1.EnableControls;
            Button16.Caption := 'SearchMode Off'
        end;
    ExDBGrid1.SetFocus;
end;

end.

